////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
class DFF extends Mutator config(DanishSpawnProtect);

var	bool		bInitialized;
var	DFFI		BFFMaster;
var	DFFM	BFFM;
var	DSS			SS;		//Penalty class for shooting spawners
var	DSWS	SWS;	//Penalty class for shooting while spawning
var	bool		bTeamGame;

//==============================================================================
//	SOUND CONTROL
var	config	bool	bSoundInterrupt;	//makes sounds interrupt.

//	SPAWN EFFECTS
var	config	bool	bTranslucentSpawn,	//Spawn in translucent state
					bFat;				//Enable fat/thin spawn effect
var	config	int		Glow;				//Glow in translucent spawns
var	config	byte	Fat;				//Fatness in fat/thin spawns

//	HEADSHOT BONUS
var	config	bool	bHeadshotBonus;	//Enable headshot bonuses
var	config	int		HeadshotSound,	//Static headshot sound 1 through 5, 0=rand
					HeadshotFrag,	//Frag bonus for headshot
					HeadshotHealth,	//Health bonus for headshot
					HeadshotAmmo,	//Ammo bonus for headshot
					HeadshotDeath;	//Death bonus for headshot (subtracted)

//	TEAM FUNCTIONALITY
var	config	bool	bNoTeamMomentum,	//remove momentum when shooting teammate
					bTeamScoring;		//Apply bonus/penalty to team score

//	PROTECTION TIME AND PENALTY WINDOWS
var	config	int		MinProtectTime,	//Min protect time, after player moves
					MaxProtectTime;	//Max protect time, if player doesn't move

//	MESSAGES
var	config	string	SpawnStartMsg,	//Message at beginning of spawn period
					SpawnEndMsg,	//Message at end of spawn period
					SameTeamMsg,	//Message when shooting a teammate
					HeadshotMsg;	//Message when headshot is made
//==============================================================================

event PreBeginPlay()
{
	BFFM=spawn(class'DFFM');
	BFFM.LoadSounds();
	BFFMaster=spawn(class'DFFI');
	BFFMaster.bMaster=true;
	BFFMaster.BFFT=self;
	SS=spawn(class'DSS');
	SWS=spawn(class'DSWS');
}

event PostBeginPlay()
{
	if (bInitialized)
		Return;
	bInitialized = True;
	Level.Game.RegisterDamageMutator(self);
	if(level.Game.IsA('DanishTeamGame') || level.Game.IsA('TeamGamePlus'))
		bTeamGame=true;

	//SetTimer(60,true);
}

// USED FOR DEBUGGING ONLY
function Timer()
{
	local DFFI bffi;
	local int i;
	local Pawn P;

	foreach AllActors(class'DFFI',bffi)
	{
		if(!bffi.bMaster)
			i++;
	}
	log(" >>##<<##>>##<< found "$i$" DFFI classes");
	i=0;

	for(P=Level.PawnList; P!=none; P=P.nextPawn)
	{
		if((P.IsA('Bot') || P.IsA('PlayerPawn')) && P.bIsPlayer)
			i++;
	}
	log(" >>##<<##>>##<< found "$i$" Players in game");
}

function ModifyPlayer(Pawn Other)
{
	if( (Other.IsA('PlayerPawn') || Other.IsA('Bot')) && Other.bIsPlayer && !Other.IsA('Spectator'))
		BFFMaster.VerifyInfo(Other);

	super.ModifyPlayer(Other);
}

//BOT FRIENDLY
function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local	DFFI	IInfo,VInfo;
	local	PlayerReplicationInfo	IPRI,VPRI;
	local	int		iType;

	if(InstigatedBy!=none && Victim!=none)
	{
//		log("##BFF instigatedby!=none and victim!=none");

		if( (InstigatedBy.IsA('PlayerPawn') || InstigatedBy.IsA('Bot'))
		&& (Victim.IsA('PlayerPawn') || Victim.IsA('Bot'))
		&& InstigatedBy.bIsPlayer && Victim.bIsPlayer && InstigatedBy!=Victim)
		{
//			log("##DFF passed rigorous if statements");
			IInfo=BFFMaster.FindInfo(InstigatedBy);
			VInfo=BFFMaster.FindInfo(Victim);
			IPRI=InstigatedBy.PlayerReplicationInfo;
			VPRI=Victim.PlayerReplicationInfo;

//			log("    Instigator is :"$InstigatedBy.PlayerReplicationInfo.PlayerName);
//			if(IInfo!=none)
//				log("    IInfo not none");
//			if(IPRI!=none)
//				log("    IPRI not none");
//			log("    Victim is :"$Victim.PlayerReplicationInfo.PlayerName);
//			if(VInfo!=none)
//				log("    VInfo not none");
//			if(VPRI!=none)
//				log("    VPRI not none");

			if(IPRI.Team==VPRI.Team && bTeamGame ) //shooting teammate
				iType=0;
			else if(IInfo.fSP<=0 && VInfo.fSP>0) //instigator not spawning, victim is
				iType=1;
			else if(IInfo.fSP>0) //instigator is spawning
				iType=2;
			else if(DamageType=='Decapitated') //headshot
				iType=3;
			else //no spawning involved, no team involved, regular shot
				iType=4;

			ActualDamage=GetDamage(iType,ActualDamage);	//damage modification
			Momentum=GetMomentum(iType,Momentum);	//momentum modification
			Punish(iType,InstigatedBy,IInfo,Victim,VInfo);	//health,score,ammo modification
		}
	}

	Super.MutatorTakeDamage(ActualDamage,Victim,InstigatedBy,HitLocation,Momentum,DamageType);
}

function int GetDamage(int type, int damage)
{
	local int	d;

	switch (type)
	{
		case 0:	//players on same team
			d=0;
			break;
		case 1:	//non-spawner shooting a spawner
			d=0;
			break;
		case 2:	//spawner shooting another player
			d=0;
			break;
		case 3: //headshot
			d=1000*damage; //make sure we kill
			break;
		case 4:	//valid shot
			d=damage;
			break;
	}

	return d;
}

function vector GetMomentum(int type, vector momentum)
{
	local vector	m;

	switch (type)
	{
		case 0:	//players on same team
			m=vect(0,0,0);
			break;
		case 1:	//non-spawner shooting a spawner
			m=vect(0,0,0);
			break;
		case 2:	//spawner shooting another player
			m=vect(0,0,0);
			break;
		case 3: //headshot
			m=momentum;
			break;
		case 4:	//valid shot
			m=momentum;
			break;
	}

	return m;
}

function Punish(int type, Pawn I, DFFI IInfo, Pawn V, DFFI VInfo)
{


	switch (type)
	{
		case 0:	//players on same team
			PlayMedia(0,I,V);
			break;
		//======================================================================
		case 1:	//non-spawner shooting a spawner
			if(IInfo.fSS1<=0)
			{
				if(SS.InstantDeathShot==1)
				{
					IInfo.iTSS1+=1;
					IInfo.iTSHSS1+=1;
					I.Died(I,'Suicided',I.Location);
					PlayMedia(11,I,V);
				}
				else
				{
					IInfo.fSS1=SS.PenaltyTime;
					IInfo.iSS1+=1;
					IInfo.iTSS1+=1;
					IInfo.iTSHSS1+=1;
					PlayMedia(10,I,V);

					if(IInfo.iSS1>=SS.HealthShot)
					{
						I.Health-=SS.Health;
					}
					if(I.Health<=0)
					{
						I.Died(I,'Suicided',I.Location);
						PlayMedia(11,I,V);
					}
					else
					{
						if(IInfo.iSS1>=SS.FragShot)
						{
							I.PlayerReplicationInfo.Score-=SS.Frag;
							IInfo.iTBPN-=SS.Frag;
							if(bTeamGame && bTeamScoring)
							{
								TeamGamePlus(Level.Game).Teams[I.PlayerReplicationInfo.Team].Score-=SS.Frag;
								IInfo.iTBPTN-=SS.Frag;
							}
						}
						if(IInfo.iSS1>=SS.DeathShot)
						{
							I.PlayerReplicationInfo.Deaths+=SS.Death;
						}
						if (IInfo.iSS1>=SS.AmmoShot && I.Weapon.AmmoType!=none)
						{
							if ((I.Weapon.AmmoType.AmmoAmount-SS.Ammo)>0)
							{
								I.Weapon.AmmoType.AmmoAmount-=SS.Ammo;
							}
							else
							{
								I.Weapon.AmmoType.AmmoAmount=0;
							}
						}
					}
				}
			}
			else if(IInfo.fSS1>0)
			{
				IInfo.iSS1+=1;
				IInfo.iTSHSS1+=1;
				PlayMedia(12,I,V);

				if(IInfo.iSS1==SS.InstantDeathShot)
				{
					I.Died(I,'Suicided',I.Location);
					PlayMedia(11,I,V);
				}
				else
				{
					if(IInfo.iSS1>=SS.HealthShot)
					{
						I.Health-=SS.Health;
					}
					if(I.Health<=0)
					{
						I.Died(I,'Suicided',I.Location);
						PlayMedia(11,I,V);
					}
					else
					{
						if(IInfo.iSS1>=SS.FragShot)
						{
							I.PlayerReplicationInfo.Score-=SS.Frag;
							IInfo.iTBPN-=SS.Frag;
							if(bTeamGame && bTeamScoring)
							{
								TeamGamePlus(Level.Game).Teams[I.PlayerReplicationInfo.Team].Score-=SS.Frag;
								IInfo.iTBPTN-=SS.Frag;
							}
						}
						if(IInfo.iSS1>=SS.DeathShot)
						{
							I.PlayerReplicationInfo.Deaths+=SS.Death;
						}
						if (IInfo.iSS1>=SS.AmmoShot && I.Weapon.AmmoType!=none)
						{
							if ((I.Weapon.AmmoType.AmmoAmount-SS.Ammo)>0)
							{
								I.Weapon.AmmoType.AmmoAmount-=SS.Ammo;
							}
							else
							{
								I.Weapon.AmmoType.AmmoAmount=0;
							}
						}

					}
				}
			}
			break;
		//======================================================================
		case 2:	//spawner shooting another player
			if(IInfo.fSS2<=0)
			{
				if(SWS.InstantDeathShot==1)
				{
					IInfo.iTSS2+=1;
					IInfo.iTSHSS2+=1;
					I.Died(I,'Suicided',I.Location);
					PlayMedia(21,I,V);
				}
				else
				{
					IInfo.fSS2=SWS.PenaltyTime;
					IInfo.iSS2+=1;
					IInfo.iTSS2+=1;
					IInfo.iTSHSS2+=1;
					PlayMedia(20,I,V);

					if(IInfo.iSS2>=SWS.HealthShot)
					{
						I.Health-=SWS.Health;
					}
					if(I.Health<=0)
					{
						I.Died(I,'Suicided',I.Location);
						PlayMedia(21,I,V);
					}
					else
					{
						if(IInfo.iSS2>=SWS.FragShot)
						{
							I.PlayerReplicationInfo.Score-=SWS.Frag;
							IInfo.iTBPN-=SWS.Frag;
							if(bTeamGame && bTeamScoring)
							{
								TeamGamePlus(Level.Game).Teams[I.PlayerReplicationInfo.Team].Score-=SWS.Frag;
								IInfo.iTBPTN-=SWS.Frag;
							}
						}
						if(IInfo.iSS2>=SWS.DeathShot)
						{
							I.PlayerReplicationInfo.Deaths+=SWS.Death;
						}
						if (IInfo.iSS2>=SWS.AmmoShot && I.Weapon.AmmoType!=none)
						{
							if ((I.Weapon.AmmoType.AmmoAmount-SWS.Ammo)>0)
							{
								I.Weapon.AmmoType.AmmoAmount-=SWS.Ammo;
							}
							else
							{
								I.Weapon.AmmoType.AmmoAmount=0;
							}
						}
					}
				}
			}
			else if(IInfo.fSS2>0)
			{
				IInfo.iSS2+=1;
				IInfo.iTSHSS2+=1;
				PlayMedia(22,I,V);

				if(IInfo.iSS2==SWS.InstantDeathShot)
				{
					I.Died(I,'Suicided',I.Location);
					PlayMedia(21,I,V);
				}
				else
				{
					if(IInfo.iSS2>=SWS.HealthShot)
					{
						I.Health-=SWS.Health;
					}
					if(I.Health<=0)
					{
						I.Died(I,'Suicided',I.Location);
						PlayMedia(21,I,V);
					}
					else
					{
						if(IInfo.iSS2>=SWS.FragShot)
						{
							I.PlayerReplicationInfo.Score-=SWS.Frag;
							IInfo.iTBPN-=SWS.Frag;
							if(bTeamGame && bTeamScoring)
							{
								TeamGamePlus(Level.Game).Teams[I.PlayerReplicationInfo.Team].Score-=SWS.Frag;
								IInfo.iTBPTN-=SWS.Frag;
							}
						}
						if(IInfo.iSS2>=SWS.DeathShot)
						{
							I.PlayerReplicationInfo.Deaths+=SWS.Death;
						}
						if (IInfo.iSS2>=SWS.AmmoShot && I.Weapon.AmmoType!=none)
						{
							if ((I.Weapon.AmmoType.AmmoAmount-SWS.Ammo)>0)
							{
								I.Weapon.AmmoType.AmmoAmount-=SWS.Ammo;
							}
							else
							{
								I.Weapon.AmmoType.AmmoAmount=0;
							}
						}

					}
				}
			}
			break;
		//======================================================================
		case 3:	//headshot
			IInfo.iTHS+=1;
			IInfo.iTVSH+=1;
			if(bHeadshotBonus)
			{
				I.PlayerReplicationInfo.Score+=HeadshotFrag;
				IInfo.iTBPP+=HeadshotFrag;
				I.PlayerReplicationInfo.Deaths-=HeadshotDeath;
				I.Health+=HeadshotHealth;
				I.Weapon.AmmoType.AmmoAmount+=HeadshotAmmo;
				PlayMedia(30,I,V);
				if(bTeamGame && bTeamScoring)
				{
					TeamGamePlus(Level.Game).Teams[I.PlayerReplicationInfo.Team].Score+=HeadshotFrag;
					IInfo.iTBPTP+=HeadshotFrag;
				}
			}
			break;
		//======================================================================
		case 4:	//valid shot
			IInfo.iTVSH+=1;
			PlayMedia(40,I,V);
			break;
	}
}

//BOT FRIENDLY
function PlayMedia(int type,Pawn I,Pawn V)
{
	local	int	q,hs;

	//Be very careful about trying to make bots play sounds. Since this code
	//only tries to play sounds on the instigator "I," a check on "I" at the
	//beginning will make sure the function exits before playing media on bots.
	//Note that only playerpawns and bots get this far, or we'd have to check
	//against all valid types (like playerpawn) before playing sounds as well.
 	if(I.IsA('Bot'))
 		return;

	switch (type)
	{
		//	PLAYERS ON SAME TEAM
		case 0:
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.pstlhit1br',false,false);
			for(q=0; BFFM.sndSameTeam[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSameTeam[q],bSoundInterrupt,true);
			}
			if(SameTeamMsg!="")
				PlayerPawn(I).ClientMessage(SameTeamMsg);
			break;
		//======================================================================
		//	NON-SPAWNER SHOOTING A SPAWNER
		case 10: //first shot
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BreakGlass',false,false);
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BarrelMove',false,false);
			for(q=0; BFFM.sndSpawnShooterInit[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnShooterInit[q],bSoundInterrupt,true);
			}
			if(SS.SpawnMsg!="")
				PlayerPawn(I).ClientMessage(SS.SpawnMsg,'CriticalEvent',true);
			break;
		case 11: //die from instant death or health penalties
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.yell1sl',false,false);
			for(q=0; BFFM.sndSpawnShooterDie[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnShooterDie[q],bSoundInterrupt,true);
			}
			break;
		case 12: //subsequent shots in penalty window
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BarrelMove',false,false);
			for(q=0; BFFM.sndSpawnShooterSubs[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnShooterSubs[q],bSoundInterrupt,true);
			}
			break;
		//======================================================================
		//	SPAWNER SHOOTING ANOTHER PLAYER
		case 20: //first shot
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BreakGlass',false,false);
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BarrelMove',false,false);
			for(q=0; BFFM.sndSpawnerShooterInit[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnerShooterInit[q],bSoundInterrupt,true);
			}
			if(SWS.SpawnMsg!="")
				PlayerPawn(I).ClientMessage(SWS.SpawnMsg,'CriticalEvent',true);
			break;
		case 21: //die from instant death or health penalties
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.yell1sl',false,false);
			for(q=0; BFFM.sndSpawnerShooterDie[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnerShooterDie[q],bSoundInterrupt,true);
			}
			break;
		case 22: //subsequent shots in penalty window
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.BarrelMove',false,false);
			for(q=0; BFFM.sndSpawnerShooterSubs[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnerShooterSubs[q],bSoundInterrupt,true);
			}
			break;
		//======================================================================
		//	HEADSHOT
		case 30:
			if(HeadshotMsg!="")
				PlayerPawn(I).ClientMessage(HeadshotMsg);
			//if the headshot sound is set, play the static or rand sound
			if(BFFM.sndHeadShotSize > 0)
			{
				if(HeadshotSound < 0 || HeadshotSound >= BFFM.sndHeadShotSize)
					hs=rand(BFFM.sndHeadShotSize);
				else
					hs=HeadshotSound;

				PlayerPawn(I).ClientPlaySound(BFFM.sndHeadShot[hs],bSoundInterrupt,true);
			}
			//if not, then send it to the regular hit media
			else
			{
				PlayMedia(40,I,V);
				//PlayerPawn(I).ClientPlaySound(Sound'UnrealShare.Stinger.StingerFire',false,false);
			}
			break;
		//======================================================================
		//	VALID SHOT
		case 40:
			//PlayerPawn(I).ClientPlaySound(Sound'UnrealShare.Stinger.StingerFire',false,false);
			for(q=0; BFFM.sndValidHit[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndValidHit[q],bSoundInterrupt,true);
			}
			break;
		//======================================================================
		//	SPAWN PERIOD OVER
		case 50:
			//PlayerPawn(I).ClientPlaySound(sound'UMenu.BigSelect',false,true);
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.Beep',false,true);
			//PlayerPawn(I).ClientPlaySound(sound'UTMenu.SpeechWindowClick',false,true);
			for(q=0; BFFM.sndSpawnEnd[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnEnd[q],bSoundInterrupt,true);
			}
			if(SpawnStartMsg!="")
				PlayerPawn(I).ClientMessage(SpawnEndMsg);
			break;
		//======================================================================
		//	SPAWN PERIOD BEGINS
		case 60:
			//PlayerPawn(I).ClientPlaySound(sound'UnrealShare.pray1n',false,true);
			for(q=0; BFFM.sndSpawnStart[q]!=none; q++)
			{
				PlayerPawn(I).ClientPlaySound(BFFM.sndSpawnStart[q],bSoundInterrupt,true);
			}
			if(SpawnEndMsg!="")
				PlayerPawn(I).ClientMessage(SpawnStartMsg);
			break;
	}
}

//removing the b__sound options, going to use the sound
//arrays only. if the sound isn't there, it isn't played.
defaultproperties
{
	bHidden=True
}
